<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Newland\Toubiz\Sync\Neos\Domain\Model\Category;
use Neos\Flow\Annotations as Flow;

trait HasCategories
{
    /**
     * @Flow\Transient
     * @Flow\IgnoreValidation
     * @var Category[]|null
     */
    protected $categoriesSorted;

    public function getCategoriesSorted(): array
    {
        // Sort and cache relations only on first call.
        if ($this->categoriesSorted === null) {
            $this->categoriesSorted = $this->categories->toArray();
            if ($this instanceof SortableRelationsInterface) {
                $this->categoriesSorted = $this->getSortedRelations('categories', 'originalId');
            }
        }

        return $this->categoriesSorted;
    }
}
