<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\ORM\Mapping as ORM;

trait HasCanonicalUrl
{
    /**
     * @ORM\Column(nullable=true)
     * @var string|null A static canonical url for this item.
     */
    protected $canonicalUrl;

    public function setCanonicalUrl(?string $canonicalUrl): void
    {
        $this->canonicalUrl = $canonicalUrl;
    }

    public function getCanonicalUrl(): ?string
    {
        return $this->canonicalUrl;
    }
}
