<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use JsonSerializable;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureExternalLinkAdapter;

/**
 * A collection of Brochure External Links data.
 * @deprecated This model will be removed in the future.
 */
class BrochureExternalLink implements JsonSerializable
{
    /** @var string */
    protected $externalId;

    /** @var string */
    protected $text;

    /** @var string */
    protected $group;

    /** @var string */
    protected $value;

    public function getExternalId(): string
    {
        return $this->externalId;
    }

    public function setExternalId(string $externalId): void
    {
        $this->externalId = $externalId;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getGroup(): string
    {
        return $this->group;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function __construct(BrochureExternalLinkAdapter $data)
    {
        $this->externalId = $data->getExternalId();
        $this->text = $data->getText();
        $this->group = $data->getGroup();
        $this->value = $data->getValue();
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
