<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Sync\Neos\Orm\Uuid\CustomUuidGeneration;
use Newland\Toubiz\Sync\Neos\Orm\Uuid\UuidGenerator;
use Newland\Toubiz\Sync\Neos\Translation\TranslatableEntity;
use Ramsey\Uuid\UuidInterface;

/**
 * @Flow\Entity()
 */
class Award extends AbstractEntity implements CustomUuidGeneration
{
    use TranslatableEntity;

    public function generateUuid(): UuidInterface
    {
        return UuidGenerator::uuidFromProperties([
            $this->originalId,
            $this->relatedArticleOriginalId,
            $this->language
        ]);
    }

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    protected $description;

    /**
     * @var string
     * @ORM\Column(type="string", length=50)
     */
    protected $iconName;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $image;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     */
    protected $value;

    /**
     * @var bool
     */
    protected $showInList;

    /**
     * @ORM\ManyToOne(inversedBy="awards")
     * @var Article|null
     */
    protected $article;

    /**
     * @var string
     */
    protected $relatedArticleOriginalId;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $validFrom;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $validUntil;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $awardSetName;

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    public function getIconName(): string
    {
        return $this->iconName;
    }

    public function setIconName(string $iconName): void
    {
        $this->iconName = $iconName;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): void
    {
        $this->image = $image;
    }

    public function getRelatedArticleOriginalId(): ?string
    {
        return $this->relatedArticleOriginalId;
    }

    public function setRelatedArticleOriginalId(?string $relatedArticleOriginalId): void
    {
        $this->relatedArticleOriginalId = $relatedArticleOriginalId;
    }

    public function getValue(): ?float
    {
        return $this->value;
    }

    public function setValue(?float $value): void
    {
        $this->value = $value;
    }

    public function getArticle(): ?Article
    {
        return $this->article;
    }

    public function setArticle(?Article $article): void
    {
        $this->article = $article;
    }

    public function getShowInList(): bool
    {
        return $this->showInList;
    }

    public function setShowInList(bool $showInList): void
    {
        $this->showInList = $showInList;
    }

    public function getValidFrom(): ?string
    {
        return $this->validFrom;
    }

    public function setValidFrom(?string $validFrom): void
    {
        $this->validFrom = $validFrom;
    }

    public function getValidUntil(): ?string
    {
        return $this->validUntil;
    }

    public function setValidUntil(?string $validUntil): void
    {
        $this->validUntil = $validUntil;
    }

    public function getAwardSetName(): ?string
    {
        return $this->awardSetName;
    }

    public function setAwardSetName(?string $awardSetName): void
    {
        $this->awardSetName = $awardSetName;
    }
}
