<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\PersistenceObjectIdentifier;

abstract class AbstractEntity implements \JsonSerializable
{
    use PersistenceObjectIdentifier;

    /**
     * Id of the entity in the external system it originates from.
     * More ids may also exist in the `externalIds` relation.
     *
     * @var string|null
     * @ORM\Column(length=50)
     */
    protected $originalId;

    public function getOriginalId(): ?string
    {
        return $this->originalId;
    }

    public function setOriginalId(?string $originalId): void
    {
        $this->originalId = $originalId;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
