<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Service\PackageClientFilterService;

/**
 * Article filter class.
 */
class PackageFilter extends AbstractFilter
{
    /**
     * @var array
     */
    protected $categories = [];

    /**
     * @var string
     */
    protected $currentSite = '';

    /**
     * @var string[]
     */
    protected $identifiers = [];

    /**
     * @var PackageClientFilterService
     * @Flow\Inject()
     */
    protected $filterService;

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return self
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
        return $this;
    }

    public function setIdentifiers(array $identifiers): void
    {
        $this->identifiers = $identifiers;
    }

    public function getIdentifiers(): array
    {
        return $this->identifiers;
    }

    public function setCurrentSite(string $currentSite): void
    {
        $this->currentSite = $currentSite;
    }

    public function getCurrentSite(): string
    {
        return $this->currentSite;
    }

    public function getClient(): string
    {
        return $this->filterService->getClientBySite($this->currentSite);
    }
}
