<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

/**
 * Article filter class.
 */
class ArticleFilter extends AbstractFilter
{
    /**
     * @var array
     */
    protected $categories = [];

    /**
     * Field to match for categories.
     *
     * Default ist persistence_object_identifier, but e.g. the
     * category mapping returns originalId values.
     *
     * @var string
     */
    protected $categoriesIdentifierField = 'Persistence_Object_Identifier';

    /**
     * @var int|null
     */
    protected $mainType;

    /**
     * @var string|null
     */
    protected $currentSite = '';

    /**
     * @var array
     */
    protected $zips = [];

    /**
     * @var bool
     */
    protected $excludeUnsafeCoordinates = false;

    /**
     * @var string[]
     */
    protected $identifiers = [];

    /**
     * @var array
     */
    protected $attributesIn = [];

    /**
     * @var array
     */
    protected $attributesRange = [];

    public function initialize(array $config)
    {
        parent::initialize($config);
        return $this;
    }

    /**
     * @param array $categories
     * @return self
     */
    public function setCategories(array $categories): self
    {
        $this->categories = $categories;
        return $this;
    }

    /**
     * @param Category[] $categories
     */
    public function setCategoryCollection(iterable $categories): self
    {
        $this->categories = [];
        foreach ($categories as $category) {
            $this->categories[] = $category->getPersistenceObjectIdentifier();
        }
        return $this;
    }

    public function getCategories(): array
    {
        return $this->categories;
    }

    public function setCategoriesIdentifierField(string $fieldName): self
    {
        $this->categoriesIdentifierField = $fieldName;
        return $this;
    }

    public function getCategoriesIdentifierField(): string
    {
        return $this->categoriesIdentifierField;
    }

    public function setMainType(?int $mainType): self
    {
        $this->mainType = $mainType;
        return $this;
    }

    public function getMainType(): ?int
    {
        return $this->mainType;
    }

    public function getZips(): array
    {
        return $this->zips;
    }

    public function setZips(array $zips): self
    {
        $this->zips = $zips;
        return $this;
    }

    public function getExcludeUnsafeCoordinates(): bool
    {
        return $this->excludeUnsafeCoordinates;
    }

    public function setExcludeUnsafeCoordinates(bool $excludeUnsafeCoordinates): self
    {
        $this->excludeUnsafeCoordinates = $excludeUnsafeCoordinates;
        return $this;
    }

    public function setIdentifiers(array $identifiers): self
    {
        $this->identifiers = $identifiers;
        return $this;
    }

    public function getIdentifiers(): array
    {
        return $this->identifiers;
    }

    public function setCurrentSite(string $currentSite): self
    {
        $this->currentSite = $currentSite;
        return $this;
    }

    public function getCurrentSite(): ?string
    {
        return $this->currentSite;
    }

    public function setAttributesIn(array $attributes): self
    {
        $this->attributesIn = $attributes;
        return $this;
    }

    public function getAttributesIn(): array
    {
        return $this->attributesIn;
    }

    public function setAttributesRange(array $attributes): self
    {
        $this->attributesRange = $attributes;
        return $this;
    }

    public function getAttributesRange(): array
    {
        return $this->attributesRange;
    }
}
