<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * A multimedia item.
 *
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="import_ident", columns={"originalid"})
 * })
 */
class Medium extends AbstractEntity
{
    /**
     * @ORM\ManyToMany(
     *     targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article",
     *     mappedBy="media",
     *     fetch="LAZY"
     * )
     * @var Collection<Article>
     */
    protected $articles;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event",
     *     mappedBy="media",
     *     fetch="LAZY"
     * )
     * @var Collection<Event>
     */
    protected $events;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Package",
     *     mappedBy="media",
     *     fetch="LAZY"
     * )
     * @var Collection<Package>
     */
    protected $packages;

    /**
     * @var string
     * @ORM\Column(type="text", nullable=true)
     */
    protected $title;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    protected $sourceUri;

    /**
     * @var string
     * @ORM\Column(nullable=true)
     */
    protected $copyright;

    /**
     * @var int
     * @ORM\Column(nullable=true)
     */
    protected $sorting;

    /**
     * Class constructor.
     *
     * This constructor is called before hydration and dependency
     * injection is happening.
     *
     * @return void
     */
    public function __construct()
    {
        $this->articles = new ArrayCollection;
        $this->events = new ArrayCollection;
    }

    /**
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $sourceUri
     * @return void
     */
    public function setSourceUri($sourceUri)
    {
        $this->sourceUri = $sourceUri;
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return $this->sourceUri;
    }

    /**
     * @param string $copyright
     * @return void
     */
    public function setCopyright($copyright)
    {
        $this->copyright = $copyright;
    }

    /**
     * @return string
     */
    public function getCopyright()
    {
        return $this->copyright;
    }

    /**
     * @param integer $sorting
     * @return void
     */
    public function setSorting($sorting)
    {
        $this->sorting = $sorting;
    }

    /**
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }
}
