<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Translation\TranslatableEntity;

/**
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="import_ident", columns={"language", "originalid"})
 * })
 */
class Category extends AbstractEntity
{

    use TranslatableEntity;

    /**
     * @var string
     */
    protected $title;

    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="categories",
     *     fetch="LAZY")
     * @var Collection<Article>
     */
    protected $articles;

    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event", mappedBy="categories", fetch="LAZY")
     * @var Collection<Event>
     */
    protected $events;

    public function __construct()
    {
        $this->events = new ArrayCollection();
        $this->articles = new ArrayCollection();
    }

    /**
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @return Collection
     */
    public function getArticles(): Collection
    {
        return $this->articles;
    }
}
