<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use JsonSerializable;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureTargetAdapter;

/**
 * A collection of Brochure Target data.
 *
 */
class BrochureTarget implements JsonSerializable
{
    /**
     * @var string
     */
    protected $externalId;

    /**
     * @var string
     */
    protected $text;

    /**
     * @var string
     */
    protected $group;

    /**
     * @var string
     */
    protected $value;

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return $this->externalId;
    }

    /**
     * @param string $externalId
     */
    public function setExternalId(string $externalId): void
    {
        $this->externalId = $externalId;
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @return string
     */
    public function getGroup(): string
    {
        return $this->group;
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * Constructor.
     *
     * @param BrochureTargetAdapter $data
     * @return void
     */
    public function __construct($data)
    {
        $this->externalId = $data->getExternalId();
        $this->text = $data->getText();
        $this->group = $data->getGroup();
        $this->value = $data->getValue();
    }


    /**
     * Specify data which should be serialized to JSON
     *
     * @link https://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return get_object_vars($this);
    }
}
