# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.6.0] - 2019-04-17
### Added
- Article Sync Command now clears cache after it finishes.
- `/redirect/{type}/*` Endpoint to handle generic endpoints as defined by `toubiz-api`.
- Ticket contact field is now imported for events.
- Brochure models and API access has been added
- Social media information for articles
- `events:synchronizeOne` command

### Changed
- `openingTypeFormat` on `Article` has been renamed to `openingTimesFormat`. This is not a breaking
  change as this attribute has not been used anywhere yet.

## [1.5.0] - 2019-04-03
### Added
- Addresses can now use geo location services to retrieve zip codes (for region filtering)
- Every API Service can now be configured with an additional `baseUri` option allowing integrators
  to point Neos to different instances of Services (e.g. TPortal staging server).
- All removal tasks now ask for confirmation before really deleting entities.

### Fixed
- Path cache is now flushed after imports preventing URLs ending in `-1`.
- `doctrine/collections` is now pinned to 1.5.0 to prevent version conflicts.
- Adresses with coordinates close to 0/0 (e.g. 0.02/0.04) are now being ignored.
- A whole import does not fail anymore if a single import step fails.

## [1.4.0] - 2019-03-08
### Added
- Synchronization CommandControllers now emit the `start` `progress` and `end`
  signals that make hooking into the synchronization process easier.
- All synchronization CommandControllers now output status information. Use the `--quiet` to disable them.
- Attribute collections are now countable
- The `articles:synchronize` now has a `--time-to-live` option that deletes records older than x days.
- New `articles:synchronizeTours` command that only synchronizes tours
- New setting `expireDays` that defines the days an deactivated or expired event should stay reachable.

### Fixed
- `CategoryFilter` now correctly sets `toDate` in initialize method
- Fixed query for incorrect field `originalid` in `RegionRepository`
- For gastronomy articles only those with the `online=1` attribute are being imported.

### Removed
- `AbstractCommandController` has been moved to the `Newland.NeosCommon` package

### Migration notes
- Use `php flow snowreport:synchronize` to ensure all requested fields are filled out.

## [1.3.2] 2019-02-07
### Fixed
- Removed migrations that assume the database to be in a defined state as most databases are not in that state.
  For the time being projects / site packages are in charge of migrations as they know their own state best.


