<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventDateFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventFactory;

class EventRepositoryTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var EventFactory */
    protected $factory;

    /** @var EventDateFactory */
    protected $dateFactory;

    /** @var EventRepository */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new EventFactory($this->objectManager);
        $this->dateFactory = new EventDateFactory($this->objectManager);
        $this->subject = $this->objectManager->get(EventRepository::class);
    }

    public function testFindAllForDataSourceRespectsLanguage(): void
    {
        $french = $this->factory->create([ 'language' => 'fr' ]);
        $this->dateFactory->create([ 'language' => 'fr', 'event' => $french ]);
        $spanish = $this->factory->create([ 'language' => 'es' ]);
        $this->dateFactory->create([ 'language' => 'es', 'event' => $spanish ]);

        $this->subject->setLanguage('fr');
        $result = $this->subject->findAllForDataSource(new \DateTime('1970-01-01T00:00:00'));
        $this->assertCount(1, $result, 'Only one result should be found');
        $this->assertEquals($french->getPersistenceObjectIdentifier(), $result[0]['value'], 'Should find french');
        $this->assertNotEquals($spanish->getPersistenceObjectIdentifier(), $result[0]['value'], 'Should not find spanish');
    }
}