<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Tests\Factory;


use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;

/**
 * @method Attribute create(array $properties = [])
 */
class AttributeFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $attribute = new Attribute();
        $attribute->setName($properties['name'] ?? $this->faker->word);
        $attribute->setData($properties['data'] ?? $this->faker->paragraph);
        $attribute->setIdentificationHash($properties['identificationHash'] ?? $this->faker->md5);
        return $attribute;
    }
}
