<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20191029102637 extends AbstractMigration
{

    public function up(Schema $schema): void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_zipcode CHANGE zipcode zipcode VARCHAR(20) NOT NULL');
    }

    public function down(Schema $schema): void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_zipcode CHANGE zipcode zipcode VARCHAR(5) NOT NULL COLLATE utf8mb4_unicode_ci');
    }
}
