<?php
namespace Newland\Toubiz\Sync\Neos\Command;

use Newland\Toubiz\Sync\Neos\Domain\Model\AbstractEntity;

interface OrphanFinder
{
    /**
     * Returns orphan objects (e.g. they are used nowhere and can safely be deleted
     * without any consequences).
     *
     * @return iterable
     */
    public function findOrphans();

    /**
     * @param AbstractEntity $entity
     * @return void
     */
    public function remove($entity);
}
