<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;

class AddressAdapterMock implements AddressAdapterInterface
{

    /** @var array */
    public $properties = [];

    public function __construct(array $properties)
    {
        $this->properties = $properties;
    }

    public function getTitle()
    {
        return $this->properties['title'] ?? null;
    }

    public function getFirstName()
    {
        return $this->properties['firstName'] ?? null;
    }

    public function getLastName()
    {
        return $this->properties['lastName'] ?? null;
    }

    public function getStreet()
    {
        return $this->properties['street'] ?? null;
    }

    public function getZip()
    {
        return $this->properties['zip'] ?? null;
    }

    public function getCity()
    {
        return $this->properties['city'] ?? null;
    }

    public function getPhoneNumber()
    {
        return $this->properties['phoneNumber'] ?? null;
    }

    public function getFaxNumber()
    {
        return $this->properties['faxNumber'] ?? null;
    }

    public function getEmailAddress()
    {
        return $this->properties['emailAddress'] ?? null;
    }

    public function getWebsiteAddress()
    {
        return $this->properties['websiteAddress'] ?? null;
    }

    public function getLatitude()
    {
        return $this->properties['latitude'] ?? null;
    }

    public function getLongitude()
    {
        return $this->properties['Longitude'] ?? null;
    }

    public function isLookup(): bool
    {
        return $this->properties['isLookup'] ?? false;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }
}
