<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

class Version20190722152400 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return 'Set the client on all articles to "default"';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('UPDATE newland_toubiz_sync_neos_domain_model_article SET client = \'default\' WHERE client LIKE \'\' OR client IS NULL');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('UPDATE newland_toubiz_sync_neos_domain_model_article SET client = NULL WHERE client LIKE \'default\'');
    }
}
