<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Command\Task;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\Constants\Language;
use Newland\Toubiz\Sync\Neos\Command\Helper\ApiServiceHelper;
use Newland\Toubiz\Sync\Neos\Command\Helper\ConfigurationHelper;
use Newland\Toubiz\Sync\Neos\Importer\ArticleImporter;

class SynchronizeLodgingsFromTportal implements SynchronizationTask
{


    /**
     * @var ApiServiceHelper
     * @Flow\Inject()
     */
    protected $apiServiceHelper;

    public function name(): string
    {
        return 'Lodgings';
    }

    public function configurations(ConfigurationHelper $configurationHelper): \Generator
    {
        $configuration = $configurationHelper->getConfigurationForService('Tportal/Api');
        if (!$configuration) {
            return;
        }

        foreach ($configuration['clients'] ?? [] as $clientConfig) {
            $clientConfig['detailUri'] = $clientConfig['detailUri'] ?? null;
            foreach ($clientConfig['languages'] ?? $configuration['languages'] ?? [ Language::DE ] as $language) {
                $clientConfig['language'] = $language;
                yield $clientConfig;
            }
        }
    }

    public function synchronize(
        array $configuration,
        \Closure $errorHandlerWrapper,
        \Closure $onProgress
    ): SynchronizationResult {

        /** @var \Newland\Toubiz\Api\Service\Tportal\ApiService $service */
        $service = $this->apiServiceHelper->initializeApiServiceWithCommonConfigurationOptions(
            'Tportal/Api',
            $configuration
        );
        $service->setDetailUriTemplate($configuration['detailUri'] ?? null);

        $processed = 0;
        $ids = [];
        $result = $service->fetchLodgings(
            $errorHandlerWrapper(
                function ($record, ?int $total) use (&$processed, &$ids, $onProgress, $configuration) {
                    $onProgress(++$processed, $total);
                    $importer = new ArticleImporter();
                    $importer->setClient($configuration['client']);
                    $importer->setLanguage($configuration['language']);
                    $ids[] = $importer->import($record)->getPersistenceObjectIdentifier();
                }
            )
        );

        return SynchronizationResult::fromServiceResult($result, $ids);
    }
}
