<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class EntityList
{
    /**
     * @var string
     */
    protected $type;

    /**
     * @var string
     */
    protected $title = '';

    /**
     * @var array
     */
    protected $identifiers = [];

    public function __construct(string $type = null, array $identifiers = [])
    {
        if ($type) {
            $this->type = $type;
        }
        $this->identifiers = $identifiers;
    }

    public function setType($type): void
    {
        $this->type = $type;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    public function getIdentifiers(): array
    {
        return $this->identifiers;
    }

    public function setIdentifiers(array $identifiers): void
    {
        $this->identifiers = $identifiers;
    }
}
