<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;
use Newland\Toubiz\Sync\Neos\Importer\EventDateImporter;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventDateFactory;
use Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock\EventDateAdapterMock;

class EventDateImporterTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var EventDateImporter */
    protected  $subject;

    /** @var EventDateFactory */
    protected $factory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(EventDateImporter::class);
        $this->factory = new EventDateFactory($this->objectManager);
    }

    public function testReusesGivenModelIfSpecified(): void
    {
        $date = $this->factory->create();
        $imported = $this->subject->import(new EventDateAdapterMock([ ]), $date);

        $this->assertEquals($imported->getPersistenceObjectIdentifier(), $date->getPersistenceObjectIdentifier());
    }

    public function testUsingSameExternalIdAsExistingModelDoesNotAutomaticallyReuseIt(): void
    {
        $date = $this->factory->create([ 'language' => 'de' ]);
        $this->subject->setLanguage('en');
        $imported = $this->subject->import(new EventDateAdapterMock([ 'externalId' => $date->getOriginalId() ]), null);

        $this->assertNotEquals($imported->getPersistenceObjectIdentifier(), $date->getPersistenceObjectIdentifier());
    }

    public function testUsingSameExternalIdDoesNotYieldSameModel(): void
    {
        $this->subject->setLanguage('de');
        $first = $this->subject->import(new EventDateAdapterMock([ 'externalId' => 'foo' ]), null);
        $this->subject->setLanguage('en');
        $second = $this->subject->import(new EventDateAdapterMock([ 'externalId' => 'foo' ]), null);

        $this->assertNotEquals($first->getPersistenceObjectIdentifier(), $second->getPersistenceObjectIdentifier());
    }
}
