<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;

class EventDateFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $date = new EventDate();

        $date->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $date->setDetailUri($properties['detailUri'] ?? $this->faker->url);
        $date->setNote($properties['note'] ?? $this->faker->text);

        $beginsAt = $properties['beginsAt'] ?? $this->faker->dateTime();
        if (!array_key_exists('endsAt', $properties)) {
            $interval = new \DateInterval('P' . random_int(60, 600). 'M');
            $properties['endsAt'] = (clone $beginsAt)->add($interval);
        }
        $date->setBeginsAt($beginsAt);
        $date->setEndsAt($properties['endsAt']);


        if (array_key_exists('language', $properties)) {
            $date->setLanguage($properties['language']);
        }
        if (array_key_exists('event', $properties)) {
            $date->setEvent($properties['event']);
        }

        return $date;
    }
}
