<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\PersistenceObjectIdentifier;

/**
 * @Flow\Entity
 */
class CityData
{
    use PersistenceObjectIdentifier;

    /**
     * @ORM\OneToOne(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="cityData")
     * @var Article
     */
    protected $city;

    /**
     * @ORM\Column(type="array", nullable=true)
     * @var array
     */
    protected $zipCodes = [];

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $idToubiz;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $idTomas;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $claim;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string|null
     */
    protected $facts;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $webcamUrl;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $webcamDescription;

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $news;

    public function getCity(): ?Article
    {
        return $this->city;
    }

    public function setCity(Article $city): void
    {
        $this->city = $city;
    }

    public function getZipCodes(): array
    {
        return $this->zipCodes ?? [];
    }

    public function setZipCodes(array $zipCodes = null): void
    {
        $this->zipCodes = $zipCodes ?? [];
    }

    public function getIdToubiz(): ?string
    {
        return $this->idToubiz;
    }

    public function setIdToubiz(?string $idToubiz): void
    {
        $this->idToubiz = $idToubiz;
    }

    public function getIdTomas(): ?string
    {
        return $this->idTomas;
    }

    public function setIdTomas(?string $idTomas): void
    {
        $this->idTomas = $idTomas;
    }

    public function getClaim(): ?string
    {
        return $this->claim;
    }

    public function setClaim(?string $claim): void
    {
        $this->claim = $claim;
    }

    public function getFacts(): ?string
    {
        return $this->facts;
    }

    public function setFacts(?string $facts): void
    {
        $this->facts = $facts;
    }

    public function getWebcamUrl(): ?string
    {
        return $this->webcamUrl;
    }

    public function setWebcamUrl(?string $webcamUrl): void
    {
        $this->webcamUrl = $webcamUrl;
    }

    public function getWebcamDescription(): ?string
    {
        return $this->webcamDescription;
    }

    public function setWebcamDescription(?string $webcamDescription): void
    {
        $this->webcamDescription = $webcamDescription;
    }

    public function getNews(): ?string
    {
        return $this->news;
    }

    public function setNews(?string $news): void
    {
        $this->news = $news;
    }
}
