<?php
namespace Newland\Toubiz\Sync\Neos\Enum;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class Enum
{

    /** @var array */
    protected static $constants;

    public static function validValue($value): bool
    {
        return \in_array($value, static::values(), true);
    }

    public static function values(): array
    {
        static::extractConstants();
        return array_values(static::$constants);
    }

    /**
     * @throws \ReflectionException
     * @return void
     */
    private static function extractConstants()
    {
        if (static::$constants) {
            return;
        }

        static::$constants = (new \ReflectionClass(static::class))->getConstants();
    }
}
