<?php


use Neos\Flow\Persistence\Doctrine\PersistenceManager;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\Weather;
use Newland\Toubiz\Sync\Neos\Service\WeatherService;

class WeatherServiceTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var WeatherService */
    private $subject;

    /** @var \Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository */
    private $articleRepo;

    /** @var Article */
    private $dummyArticle;

    public function setUp(): void
    {
        parent::setUp();
        if (!$this->persistenceManager instanceof PersistenceManager) {
            $this->markTestSkipped('Doctrine persistence is not enabled');
        }
        $this->subject = new WeatherService();
        $this->dummyArticle = new Article();
    }

    public function testSearchingForNonCityArticle()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->dummyArticle->setMainType(ArticleConstants::TYPE_TOUR);
        $this->subject->findByCityArticle($this->dummyArticle);
    }

    public function testFetchingAnExistingCityWithoutGeoLocation()
    {
        $this->expectException(\GuzzleHttp\Exception\RequestException::class);
        $this->dummyArticle->setMainType(ArticleConstants::TYPE_CITY);
        $this->dummyArticle->setName('Aach');
        $weather = $this->subject->findByCityArticle($this->dummyArticle);
        $this->assertInstanceOf(Weather::class, $weather);
    }

    public function testFetchingAnExistingCityWithGeoLocation()
    {
        $this->dummyArticle->setMainType(ArticleConstants::TYPE_CITY);
        $this->dummyArticle->setName('Aach');
        $this->dummyArticle->setLatitude(47.843221);
        $this->dummyArticle->setLongitude(8.852687);
        $weather = $this->subject->findByCityArticle($this->dummyArticle);
        $this->assertInstanceOf(Weather::class, $weather);
    }
}
