<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * A multimedia item.
 *
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="newland_toubiz_sync_neos_medium_import_ident", columns={"originalid"})
 * })
 */
class Medium extends AbstractEntity
{
    /**
     * @ORM\ManyToMany(
     *     targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article",
     *     mappedBy="media",
     *     fetch="LAZY"
     * )
     * @var Collection<Article>
     */
    protected $articles;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event",
     *     mappedBy="media",
     *     fetch="LAZY"
     * )
     * @var Collection<Event>
     */
    protected $events;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Package",
     *     mappedBy="media",
     *     fetch="LAZY"
     * )
     * @var Collection<Package>
     */
    protected $packages;

    /**
     * @var string|null
     * @ORM\Column(type="text", nullable=true)
     */
    protected $title;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    protected $sourceUri;

    /**
     * @var string|null
     * @ORM\Column(nullable=true)
     */
    protected $copyright;

    /**
     * @var int|null
     * @ORM\Column(nullable=true)
     */
    protected $sorting;

    public function __construct()
    {
        $this->articles = new ArrayCollection();
        $this->events = new ArrayCollection();
    }

    public function setTitle($title): void
    {
        $this->title = $title;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setSourceUri(string $sourceUri): void
    {
        $this->sourceUri = $sourceUri;
    }

    public function getSourceUri(): string
    {
        return $this->sourceUri;
    }

    public function setCopyright(?string $copyright): void
    {
        $this->copyright = $copyright;
    }

    public function getCopyright(): ?string
    {
        return $this->copyright;
    }

    public function setSorting(?int $sorting): void
    {
        $this->sorting = $sorting;
    }

    public function getSorting(): ?int
    {
        return $this->sorting;
    }
}
