<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\CityData;

class CityDataFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $cityData = new CityData();

        $cityData->setIdTomas($properties['idThomas'] ?? $this->faker->uuid);
        $cityData->setIdToubiz($properties['idToubiz'] ?? $this->faker->uuid);
        $cityData->setZipCodes($properties['zips'] ?? $this->zips());

        return $cityData;
    }

    private function zips(): array
    {
        $numberOfZips = random_int(2, 8);

        $zips = [];
        for ($i = 0; $i < $numberOfZips; $i++) {
            $zips[] = $this->zip();
        }

        return $zips;
    }

    private function zip(): string
    {
        return (string) $this->faker->numberBetween(11111, 99999);
    }
}