<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;

class EventDateFactory extends AbstractFactory
{
    public function make(array $properties = [])
    {
        $date = new EventDate();

        $beginsAt = $properties['beginsAt'] ?? $this->faker->dateTime();
        if (!array_key_exists('endsAt', $properties)) {
            $interval = new \DateInterval('P' . random_int(60, 600). 'M');
            $properties['endsAt'] = (clone $beginsAt)->add($interval);
        }
        $date->setBeginsAt($beginsAt);
        $date->setEndsAt($properties['endsAt']);

        $date->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $date->setLanguage($properties['language'] ?? 'de');
        $date->setNote($properties['note'] ?? $this->faker->paragraph);

        return $date;
    }
}