<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Faker\Generator;
use Neos\Flow\ObjectManagement\ObjectManagerInterface;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Faker\Factory as FakerFactory;

abstract class AbstractFactory
{

    /** @var Generator */
    protected $faker;

    /** @var PersistenceManagerInterface */
    protected $persistenceManager;

    /** @var ObjectManagerInterface */
    protected $objectManager;

    public function __construct(ObjectManagerInterface $objectManager, ?Generator $faker = null)
    {
        $this->objectManager = $objectManager;
        $this->persistenceManager = $objectManager->get(PersistenceManagerInterface::class);
        $this->faker = $faker ?? FakerFactory::create();
    }

    public function create(array $properties = [])
    {
        $entity = $this->make($properties);
        $this->persistenceManager->add($entity);
        $this->persistenceManager->persistAll();
        return $entity;
    }

    public function createMultiple(int $number, array $properties = []): array
    {
        $entities = [];
        for ($i = 0; $i < $number; $i++) {
            $entities[] = $this->create($properties);
        }
        return $entities;
    }

    abstract public function make(array $properties = []);

}