# Toubiz sync package

Provides functionality to synchronize API data into Neos CMS.

## Configuration

### Settings
Configure available services (data sources) inside `Settings.yaml`. The following configuration demonstrates available service configurations.

```
Newland:
  Toubiz:
    Sync:
      Neos:
        services:
          Toubiz/Legacy/EventApi:
            client: ''
            apiKey: ''
            organizer: ''
            languages:
              - de
              - en
            detailUriTemplates:
                rce: 'https://www.foobar.com/region/?eventID={rceEventId}&dateID={rceDateId}&mode=DT&redirect=1'

          Toubiz/Legacy/Db:
            client: ''
            apiKey: ''
            minLevelOfMaintenance: 60

          Toubiz/Legacy/Tportal:
            client: ''
            apikey: ''

          Sisag/Api:
            client: ''

          Tportal/CongressApi:
            clients:
              Default:
                client: mytportalclient
                detailUri: 'https://foobar.com/{tportalUriSegment}'

          Tportal/Api:
            clients:
              Default:
                client: mytportalclient
                detailUri: 'https://foobar.com/{tportalUriSegment}'
```

#### Configure weather data provider

Toubiz sync package supports 2 providers for weather data: "Meteotest" and "OpenWeatherMap".

Example configuration for "Meteotest":

```
Newland:
  Toubiz:
    Sync:
      Neos:
        dataProvider:
          weather: meteotest
        services:
          Meteotest/Api:
            apiKey: MYAPIKEY
            parameters:
              action: my_preconfigured_action
```

Example configuration for "OpenWeatherMap":

```
Newland:
  Toubiz:
    Sync:
      Neos:
        dataProvider:
          weather: openweathermap
        services:
          OpenWeatherMap/Api:
            apiKey: myapikey
            parameters:
              locations:
                Paris:
                  lat: 48.8588376
                  lon: 2.2768489
                Tokyo:
                  lat: 35.669107
                  lon: 139.6009544
                Sulzburg:
                  lat: 47.8277304
                  lon: 7.6954458
```

#### Configure Geo Location Service

If a data provider supplied geo coordinates but no physical address, you can use a geo location
service to retrieve the zip code during import.

```
Newland:
  Toubiz:
    Sync:
      Neos:
        services:
          'GeoLocation': 'Newland\Toubiz\Sync\Neos\Geometry\LocalLocationService'
```

The following providers exist:
- `Newland\Toubiz\Sync\Neos\Geometry\LocalLocationService`: Gets data out of a local mysql database.
  For this to work correctly you have to execute the `geometry:seedZipPolygons` first in order to setup
  the location database.
- `Newland\Toubiz\Api\Service\GeoLocation\NominatimService`: Uses the nominatim OpenStreetMaps API.
  Only use this provider for testing purposes.
- `Newland\Toubiz\Api\Service\GeoLocation\NullService`: Does nothing.
