<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\UuidInterface;

/**
 * Abstract entity.
 *
 * Base class for flow entities.
 */
abstract class AbstractEntity implements \JsonSerializable
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="CUSTOM")
     * @ORM\CustomIdGenerator(class="Newland\Toubiz\Sync\Neos\Orm\Uuid\UuidGenerator")
     * @ORM\Column(type="guid", unique=TRUE)
     * @var string|UuidInterface
     */
    protected $Persistence_Object_Identifier;

    public function getPersistenceObjectIdentifier(): ?string
    {
        if ($this->Persistence_Object_Identifier instanceof UuidInterface) {
            return $this->Persistence_Object_Identifier->toString();
        }

        return $this->Persistence_Object_Identifier;
    }

    public function setPersistenceObjectIdentifier(string $identifier): void
    {
        $this->Persistence_Object_Identifier = $identifier;
    }


    /**
     * Original identifier from toubiz.
     * @var string|null
     * @ORM\Column(length=50)
     */
    protected $originalId;

    public function getOriginalId(): ?string
    {
        return $this->originalId;
    }

    public function setOriginalId(?string $originalId): void
    {
        $this->originalId = $originalId;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
