# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [unreleased]
### Added
- A new `category:removeunused` command to clean out old categories that are not used for articles
  or events.
- The following entities now use persistent object identifiers. This means that the identifier of the
  entity is determined by it's properties - leading to the same object getting the same data event when
  clearing the database and reimporting. This is important because the identifiers are being used in
  multiple places. This way deleting all entities are doing a fresh import does not break existing nodes
  on the site.
    - Articles
    - Events
    - Event Dates
    - Categories
- A new `identifier:regenerate` command has been added to migrate from unstable identifiers to deterministic
  identifiers. Read more about that in the 'Action required' section.

### Fixed
- Fixed translatable repositories not adding language clauses to some queries.
- tportal services now support multiple languages.

### Action Required
- To migrate data from unstable persistence object identifiers to deterministic object identifiers the
  `identifier:regenerate` command can be used. This command regenerates the identifiers and updates all
  relations correctly. You are strongly advised to create a database backup prior to running this command.
  This command changes data in the database and thus must be run once per environment.
  Note: You may run into issues when the same category exists multiple times in your database.
  In these cases you can use the new `category:removeunused` command to remove the unused ones.

## [1.10.5] - 2019-06-25
### Fixed
- Sites using custom page node types (as opposed to the default `Neos.NodeTypes:Page`) now no longer
  fail during the 'Rebuilding URLs' phase of synchronization commands.
- Fixed incorrect cache clearing after sync commands

## [1.10.2] - 2019-06-19
### Fixed
- Fixed packages without preview images breaking imports

## [1.10.0] - 2019-06-07
### Changed
- Added a trait for unique URLs to events and articles.
- Categories are now sorted. The first category is considered the main category.
- Languages for services now must be explicitly configured. The default for imported languages has changed from all languages to just german.
– External event detail pages (e.g. to RCE events calendar) can now be build. See README for an example.

### Fixed
- `events:remove` now iterates over all configured languages.
- Article attributes are now language and client aware.
- Article import no longer creates Duplicate categories.

### Potentially Breaking / Action required
- If your website supports languages other than german (If the website is multilingual) then
  you will have to configure the languages to import from for every service configured.
  The following example shows Legacy toubiz configuration but this is true for all multilingual
  data sources.
```yaml
# Before: Implicitly imports all languages
Toubiz:
  Sync:
    Neos:
      services:
        Toubiz/Legacy/Db:
          apiKey: ABC123DEF456
          client: 1234

# After: Must configure relevant languages explicitly
Toubiz:
  Sync:
    Neos:
      services:
        Toubiz/Legacy/Db:
          apiKey: ABC123DEF456
          client: 1234
          languages:
            - de
            - en
            - es
            - fr
```

## [1.7.4] - 2019-05-17
### Added
- Language handling of repositories can now be disabled
- Repositories now have methods for easy batch handling

## [1.7.3] - 2019-05-14
### Fixed
- Fixed categories being imported with an empty string as language

## [1.7.2] - 2019-05-09
### Added
- Add new signal for URL build

## [1.7.1] - 2019-05-09
### Added
- Tables now have indexes on columns to speed up imports

### Fixed
- Invalid UTF-8 characters are now stripped from incoming data
- Memory leak for article imports has been fixed. Memory consumption does
  not scale with the number of records anymore.
- Fixed logger not being passed to DbService

## [1.7.0] - 2019-05-08
### Added
- Categories are now language-aware.
- There is now feedback on how many articles were removed during import.
- The order of images for an articles is now saved.
- Add `--only` flag for article synchronize command to allow import of a single article type.

### Changed
- PHP 7.2 and up is now required.

### Changed
- The default language for imports in now only German.

### Fixed
- Check for translations during import.
- The magic repository methods now respect the current language.
- Fixed incorrect querying when applying filters by client. By not having the `and`
condition they would override the basic filtering applied.
- Main address no longer blocks removal of articles.
- Attributes are now cleared correctly if there were any previously but not anymore.

## [1.6.1] - 2019-04-18
### Fixed
- Fixed selecting multiple articles when joining to categories
- Imported zip codes now have precedence over calculated ones.

## [1.6.0] - 2019-04-17
### Added
- Article Sync Command now clears cache after it finishes.
- `/redirect/{type}/*` Endpoint to handle generic endpoints as defined by `toubiz-api`.
- Ticket contact field is now imported for events.
- Brochure models and API access has been added
- Social media information for articles
- `events:synchronizeOne` command

### Changed
- `openingTypeFormat` on `Article` has been renamed to `openingTimesFormat`. This is not a breaking
  change as this attribute has not been used anywhere yet.

### Fixed
- List views with no category filter selected now display distinct articles, no duplicates.

## [1.5.0] - 2019-04-03
### Added
- Addresses can now use geo location services to retrieve zip codes (for region filtering)
- Every API Service can now be configured with an additional `baseUri` option allowing integrators
  to point Neos to different instances of Services (e.g. TPortal staging server).
- All removal tasks now ask for confirmation before really deleting entities.

### Fixed
- Path cache is now flushed after imports preventing URLs ending in `-1`.
- `doctrine/collections` is now pinned to 1.5.0 to prevent version conflicts.
- Adresses with coordinates close to 0/0 (e.g. 0.02/0.04) are now being ignored.
- A whole import does not fail anymore if a single import step fails.

## [1.4.0] - 2019-03-08
### Added
- Synchronization CommandControllers now emit the `start` `progress` and `end`
  signals that make hooking into the synchronization process easier.
- All synchronization CommandControllers now output status information. Use the `--quiet` to disable them.
- Attribute collections are now countable
- The `articles:synchronize` now has a `--time-to-live` option that deletes records older than x days.
- New `articles:synchronizeTours` command that only synchronizes tours
- New setting `expireDays` that defines the days an deactivated or expired event should stay reachable.

### Fixed
- `CategoryFilter` now correctly sets `toDate` in initialize method
- Fixed query for incorrect field `originalid` in `RegionRepository`
- For gastronomy articles only those with the `online=1` attribute are being imported.

### Removed
- `AbstractCommandController` has been moved to the `Newland.NeosCommon` package

### Migration notes
- Use `php flow snowreport:synchronize` to ensure all requested fields are filled out.

## [1.3.2] 2019-02-07
### Fixed
- Removed migrations that assume the database to be in a defined state as most databases are not in that state.
  For the time being projects / site packages are in charge of migrations as they know their own state best.
