<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

/**
 * Article filter class.
 */
class ArticleFilter extends AbstractFilter
{
    /**
     * @var array
     */
    protected $categories = [];

    /**
     * Field to match for categories.
     *
     * Default ist persistence_object_identifier, but e.g. the
     * category mapping returns originalId values.
     *
     * @var string
     */
    protected $categoriesIdentifierField = 'Persistence_Object_Identifier';

    /**
     * @var int|null
     */
    protected $mainType;

    /**
     * @var string|null
     */
    protected $currentSite = '';

    /**
     * @var array
     */
    protected $zips = [];

    /**
     * @var bool
     */
    protected $excludeUnsafeCoordinates = false;

    /**
     * @var string[]
     */
    protected $identifiers = [];

    /**
     * @var array
     */
    protected $attributesIn = [];

    /**
     * @var array
     */
    protected $attributesRange = [];

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return self
     */

    public function initialize(array $config)
    {
        parent::initialize($config);
        return $this;
    }

    /**
     * @param array $categories
     * @return self
     */
    public function setCategories(array $categories)
    {
        $this->categories = $categories;
        return $this;
    }

    /**
     * @param Category[] $categories
     * @return self
     */
    public function setCategoryCollection(iterable $categories)
    {
        $this->categories = [];
        foreach ($categories as $category) {
            $this->categories[] = $category->getPersistenceObjectIdentifier();
        }
        return $this;
    }

    /**
     * @return array
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * @param string $fieldName
     * @return self
     */
    public function setCategoriesIdentifierField($fieldName)
    {
        $this->categoriesIdentifierField = $fieldName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCategoriesIdentifierField()
    {
        return $this->categoriesIdentifierField;
    }

    /**
     * @param int $mainType
     * @return self
     */
    public function setMainType($mainType)
    {
        $this->mainType = $mainType;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getMainType()
    {
        return $this->mainType;
    }

    /**
     * @return array
     */
    public function getZips()
    {
        return $this->zips;
    }

    /**
     * @param array $zips
     */
    public function setZips(array $zips)
    {
        $this->zips = $zips;
    }

    /**
     * @return bool
     */
    public function getExcludeUnsafeCoordinates(): bool
    {
        return $this->excludeUnsafeCoordinates;
    }

    /**
     * @param bool $excludeUnsafeCoordinates
     */
    public function setExcludeUnsafeCoordinates(bool $excludeUnsafeCoordinates)
    {
        $this->excludeUnsafeCoordinates = $excludeUnsafeCoordinates;
    }

    public function setIdentifiers(array $identifiers)
    {
        $this->identifiers = $identifiers;
    }

    public function getIdentifiers(): array
    {
        return $this->identifiers;
    }

    public function setCurrentSite(string $currentSite)
    {
        $this->currentSite = $currentSite;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrentSite()
    {
        return $this->currentSite;
    }

    public function setAttributesIn(array $attributes)
    {
        $this->attributesIn = $attributes;
    }

    public function getAttributesIn()
    {
        return $this->attributesIn;
    }

    public function setAttributesRange(array $attributes)
    {
        $this->attributesRange = $attributes;
    }

    public function getAttributesRange()
    {
        return $this->attributesRange;
    }
}
