<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Importer\EventTagImporter;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventTagFactory;
use Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock\EventTagAdapterMock;

class EventTagImporterTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var EventTagImporter */
    protected  $subject;

    /** @var EventTagFactory() */
    protected $factory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(EventTagImporter::class);
        $this->factory = new EventTagFactory($this->objectManager);
    }


    public function testReusesGivenModelIfSpecified(): void
    {
        $tag = $this->factory->create();
        $imported = $this->subject->import(new EventTagAdapterMock([ ]), $tag);

        $this->assertEquals($imported->getPersistenceObjectIdentifier(), $tag->getPersistenceObjectIdentifier());
    }

    public function testUsingSameExternalIdAsExistingModelDoesNotAutomaticallyReuseIt(): void
    {
        $tag = $this->factory->create();
        $imported = $this->subject->import(new EventTagAdapterMock([ 'externalId' => $tag->getOriginalId() ]), null);

        $this->assertNotEquals($imported->getPersistenceObjectIdentifier(), $tag->getPersistenceObjectIdentifier());
    }

    public function testUsingSameExternalIdDoesNotYieldSameModel(): void
    {
        $first = $this->subject->import(new EventTagAdapterMock([ 'externalId' => 'foo' ]), null);
        $second = $this->subject->import(new EventTagAdapterMock([ 'externalId' => 'foo' ]), null);

        $this->assertNotEquals($first->getPersistenceObjectIdentifier(), $second->getPersistenceObjectIdentifier());
    }
}