<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\WeatherAdapterInterface;
use Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter\WeatherAdapter;

/**
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="newland_toubiz_sync_neos_weather_import_ident", columns={"originalid"})
 * })
 */
class Weather extends AbstractEntity
{
    /**
     * @ORM\Column(type="object", nullable=true)
     * @var WeatherAdapterInterface | null
     */
    protected $data;

    /**
     * @var string
     */
    protected $location;

    /**
     * @var \DateTime
     */
    protected $updatedAt;

    public function __construct(WeatherAdapterInterface $data)
    {
        $this->setData($data);
    }

    public function setData(WeatherAdapterInterface $data): void
    {
        $this->data = $data;
    }

    public function setLocation(string $location): void
    {
        $this->location = $location;
    }

    public function getLocation(): string
    {
        return $this->location;
    }

    public function setUpdatedAt(\DateTime $updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }

    public function getUpdatedAt(): \DateTime
    {
        return $this->updatedAt;
    }

    public function getForecast(): array
    {
        if ($this->data === null) {
            return [];
        }

        return $this->data->getForecast();
    }
}
