<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Command\Task;

use Newland\Toubiz\Api\Service\ServiceResult;

class SynchronizationResult
{

    public static function fromServiceResult(ServiceResult $serviceResult, array $touched): SynchronizationResult
    {
        return new static($serviceResult->getDeleted(), $serviceResult->getAll(), $touched);
    }

    /**
     * @param string[]|null $originalIdsToDelete
     * @param string[]|null $originalIdsToRetain
     * @param string[] $touchedUuids
     */
    public function __construct(?array $originalIdsToDelete, ?array $originalIdsToRetain, array $touchedUuids)
    {
        $this->originalIdsToDelete = $originalIdsToDelete;
        $this->originalIdsToRetain = $originalIdsToRetain;
        $this->touchedUuids = $touchedUuids;
    }

    /** @var string[]|null */
    private $originalIdsToRetain = null;

    /** @var string[]|null */
    private $originalIdsToDelete = null;

    /** @var string[] */
    private $touchedUuids = [];

    /** @return string[]|null */
    public function getOriginalIdsToRetain(): ?array
    {
        return $this->originalIdsToRetain;
    }

    public function getOriginalIdsToDelete(): ?array
    {
        return $this->originalIdsToDelete;
    }

    public function getTouchedUuids(): array
    {
        return $this->touchedUuids;
    }
}
