<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Command\Helper;

use Newland\Toubiz\Api\Constants\Language;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class ConfigurationHelper
{

    /**
     * @var array
     * @Flow\InjectConfiguration
     */
    protected $configuration;

    /** @var array  */
    protected $defaults = [];

    public function setDefaults(array $defaults): void
    {
        $this->defaults = $defaults;
    }

    public function getConfigurationForService($service): ?array
    {
        $configuration = $this->configuration['services'][$service] ?? null;

        if ($configuration === null) {
            return null;
        }

        $configuration['languages'] = $configuration['languages'] ?? [ Language::DE ];
        return array_replace_recursive($this->defaults, $configuration);
    }
}
