<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Sync\Neos\Enum\Currency;

/**
 * @Flow\Entity
 */
class Offer extends AbstractEntity
{

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     * @ORM\Column(type="string", nullable=true)
     */
    protected $previewImage;

    /**
     * @var float
     * @ORM\Column(type="float", nullable=true)
     */
    protected $startingPrice;

    /**
     * ISO-4217 currency code.
     * Will be validated against the `Currency` enum in the setter.
     *
     * @var string
     * @ORM\Column(type="string", length=3, options={"fixed" = true}, nullable=true)
     */
    protected $startingPriceCurrency;

    /**
     * @var integer
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $durationMinutes;

    /**
     * @var string
     * @ORM\Column(type="string", nullable=true)
     */
    protected $address;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string|null
     */
    public function getPreviewImage()
    {
        return $this->previewImage;
    }

    /**
     * @param string $previewImage
     */
    public function setPreviewImage($previewImage)
    {
        $this->previewImage = $previewImage;
    }

    /**
     * @return float
     */
    public function getStartingPrice()
    {
        return $this->startingPrice;
    }

    /**
     * @param float $startingPrice
     */
    public function setStartingPrice($startingPrice)
    {
        $this->startingPrice = $startingPrice;
    }

    /**
     * @return string
     */
    public function getStartingPriceCurrency()
    {
        return $this->startingPriceCurrency;
    }

    /**
     * @param string $startingPriceCurrency
     */
    public function setStartingPriceCurrency($startingPriceCurrency)
    {
        if ($startingPriceCurrency && !Currency::validValue($startingPriceCurrency)) {
            throw new \InvalidArgumentException(
                'The currency ' . $startingPriceCurrency . ' is undefined. ' .
                'Must be one of ' . implode(', ', Currency::values())
            );
        }
        $this->startingPriceCurrency = $startingPriceCurrency;
    }

    /**
     * @return int
     */
    public function getDurationMinutes()
    {
        return $this->durationMinutes;
    }

    /**
     * @param int $durationMinutes
     */
    public function setDurationMinutes($durationMinutes)
    {
        $this->durationMinutes = $durationMinutes;
    }

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * @param string $address
     */
    public function setAddress($address)
    {
        $this->address = $address;
    }
}
