<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

/**
 * Category filter class.
 */
class CategoryFilter extends AbstractFilter
{
    /**
     * @var int|null
     */
    protected $articleMainType;

    /**
     * @var array<Event>
     */
    protected $events;

    /**
     * @var \DateTime|null
     */
    protected $toDate;

    /**
     * @var \DateTime|null
     */
    protected $fromDate;

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return self
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        if (array_key_exists('fromDate', $config)) {
            $this->setFromDate($this->asDateTime($config['fromDate']));
        }
        if (array_key_exists('toDate', $config)) {
            $this->setToDate($this->asDateTime($config['toDate']));
        }

        return $this;
    }

    /**
     * @param int $mainType
     * @return void
     */
    public function setArticleMainType($mainType)
    {
        $this->articleMainType = $mainType;
    }

    /**
     * @return int|null
     */
    public function getArticleMainType()
    {
        return $this->articleMainType;
    }

    /**
     * @param \DateTime $fromDate
     * @return void
     */
    public function setFromDate($fromDate)
    {
        $this->fromDate = $fromDate;
    }

    /**
     * @return \DateTime|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }

    /**
     * @param \DateTime $toDate
     * @return void
     */
    public function setToDate($toDate)
    {
        $this->toDate = $toDate;
    }

    /**
     * @return \DateTime|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }
}
