<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\Domain\Model\FilterableInterface;

/**
 * @Flow\Entity
 */
class Place extends AbstractEntity implements FilterableInterface
{
    /** @var string */
    private $title;

    /** @var string */
    private $type;

    /** @var string */
    private $identifier;

    /** @var mixed|null */
    private $value;

    public function __construct(string $type, string $identifier, string $title, string $value = null)
    {
        $this->type = $type;
        $this->identifier = $identifier;
        $this->title = $title;
        $this->value = $value;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getCombinedIdentifier(): string
    {
        $identifier = $this->type . ':' . $this->identifier;
        if ($this->value) {
            $identifier .= ':' . $this->value;
        }
        return $identifier;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getValue()
    {
        return $this->value;
    }
    
    public function getValueOrIdentifier(): string
    {
        return $this->value ?? $this->identifier;
    }
}
