<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="import_ident", columns={"originalid"})
 * })
 */
class Region extends AbstractEntity
{
    /** @var string */
    protected $name;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\TransportationFacility",
     *     inversedBy="regions"
     * )
     * @ORM\JoinTable(name="newland_toubiz_sync_neos_region_transportation_facilities_join")
     * @var Collection<TransportationFacility>
     */
    protected $transportationFacilities;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Slope",
     *     inversedBy="regions"
     * )
     * @ORM\JoinTable(name="newland_toubiz_sync_neos_region_slopes_join")
     * @var Collection<Slope>
     */
    protected $slopes;

    /**
     * @ORM\Column(type="array", nullable=true)
     * @var array|null
     */
    protected $attributes;

    /**
     * @ORM\Column(nullable=true)
     * @var \DateTime|null
     */
    protected $updatedAt;

    public function __construct()
    {
        $this->slopes = new ArrayCollection();
        $this->transportationFacilities = new ArrayCollection();
    }

    public function setTransportationFacilities(Collection $facilities): void
    {
        $this->transportationFacilities = $facilities;
    }

    public function getTransportationFacilities(): Collection
    {
        return $this->transportationFacilities;
    }

    public function setSlopes(Collection $slopes): void
    {
        $this->slopes = $slopes;
    }

    public function getSlopes(): Collection
    {
        return $this->slopes;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setAttributes(array $attributes): void
    {
        $this->attributes = $attributes;
    }

    public function getAttributes(): ?array
    {
        return $this->attributes;
    }

    public function setUpdatedAt(\DateTime $updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }

    public function getUpdatedAt(): ?\DateTime
    {
        return $this->updatedAt;
    }
}
