<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * A package is a bundle of bookable hotels and services that are sold together.
 *
 * @Flow\Entity()
 * @ORM\Table(indexes={
 *      @ORM\Index(name="import_ident", columns={"originalid"})
 * })
 */
class Package extends AbstractEntity
{

    /** @var string */
    protected $name;

    /**
     * @ORM\ManyToMany(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Medium", inversedBy="packages",
     *     fetch="LAZY",
     *     cascade={"persist"})
     * @var Collection<Medium>
     */
    protected $media;

    /**
     * @ORM\OneToMany(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Benefit", mappedBy="package", fetch="LAZY",
     *     cascade={"persist", "remove"})
     * @var Collection<Benefit>
     */
    protected $benefits;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     */
    protected $minimumNights;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     */
    protected $startingPrice;

    /**
     * ISO-4217 currency code.
     *
     * @var string|null
     * @ORM\Column(type="string", length=3, options={"fixed" = true}, nullable=true)
     */
    protected $startingPriceCurrency;

    /** @var string */
    protected $client;

    public function __construct()
    {
        $this->media = new ArrayCollection();
        $this->benefits = new ArrayCollection();
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getMedia(): Collection
    {
        return $this->media;
    }

    public function setMedia(Collection $media): void
    {
        $this->media = $media;
    }

    public function getBenefits(): Collection
    {
        return $this->benefits;
    }

    public function setBenefits(Collection $benefits)
    {
        $this->benefits = $benefits;
    }

    public function getMinimumNights(): ?float
    {
        return $this->minimumNights;
    }

    public function setMinimumNights(?float $minimumNights): void
    {
        $this->minimumNights = $minimumNights;
    }

    public function getStartingPrice(): ?float
    {
        return $this->startingPrice;
    }

    public function setStartingPrice(?float $startingPrice): void
    {
        $this->startingPrice = $startingPrice;
    }

    public function getStartingPriceCurrency(): ?string
    {
        return $this->startingPriceCurrency;
    }

    public function setStartingPriceCurrency(?string $startingPriceCurrency): void
    {
        $this->startingPriceCurrency = $startingPriceCurrency;
    }

    public function getClient(): string
    {
        return $this->client;
    }

    public function setClient(string $client): void
    {
        $this->client = $client;
    }
}
