<?php

namespace Newland\Toubiz\Sync\Neos\Importer;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Repository\BrochureRepository;

/**
 * Brochure importer.
 *
 * This does not fit the rest of the importers as its data
 * is not directly bound to a model nor is the data stored
 * in the database. The whole weather modelling is pragmatic
 * and needs more work in the future!
 *
 * @Flow\Scope("singleton")
 */
class BrochureImporter extends AbstractImporter
{
    /**
     * @Flow\Inject
     * @var BrochureRepository
     */
    protected $brochureRepository;

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     * This takes the whole data response array and stores it in one
     * cache file. Thus, no object adapter exists yet, where data converting
     * should happen instead of the importer itself.
     *
     * @param array $data
     * @return void
     */
    public function import($data)
    {
        $this->brochureRepository->store($data);
    }
}
