<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use JsonSerializable;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureAdapter;

/**
 * A collection of Brochure data.
 *
 */
class Brochure implements JsonSerializable
{

    /**
     * @var string
     */
    protected $externalId;

    /**
     * @var \DateTime
     */
    protected $lastChange;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var float
     */
    protected $weight;

    /**
     * @var int
     */
    protected $flagStatus;

    /**
     * @var int
     */
    protected $prospectCount;

    /**
     * @var string
     */
    protected $size;

    /**
     * @var string
     */
    protected $address;

    /**
     * @var array
     */
    protected $locations;

    /**
     * @var array
     */
    protected $regions;

    /**
     * @var array
     */
    protected $languages;

    /**
     * @var array
     */
    protected $categories;

    /**
     * @var array
     */
    protected $targets;

    /**
     * @var array
     */
    protected $images;

    /**
     * @var array
     */
    protected $files;

    /**
     * @var array
     */
    protected $externalLinks;

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return $this->externalId;
    }

    /**
     * @param string $externalId
     */
    public function setExternalId(string $externalId)
    {
        $this->externalId = $externalId;
    }

    /**
     * @return \DateTime
     */
    public function getLastChange(): \DateTime
    {
        return $this->lastChange;
    }

    /**
     * @param \DateTime $lastChange
     */
    public function setLastChange(\DateTime $lastChange)
    {
        $this->lastChange = $lastChange;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return float
     */
    public function getWeight(): float
    {
        return $this->weight;
    }

    /**
     * @return int
     */
    public function getFlagStatus(): int
    {
        return $this->flagStatus;
    }

    /**
     * @param int $flagStatus
     */
    public function setFlagStatus(int $flagStatus)
    {
        $this->flagStatus = $flagStatus;
    }

    /**
     * @return int
     */
    public function getProspectCount(): int
    {
        return $this->prospectCount;
    }

    /**
     * @return string
     */
    public function getSize(): string
    {
        return $this->size;
    }


    /**
     * @return string
     */
    public function getAddress(): string
    {
        return $this->address;
    }

    /**
     * @return array
     */
    public function getLocations(): array
    {
        return $this->locations;
    }

    /**
     * @return array
     */
    public function getRegions(): array
    {
        return $this->regions;
    }

    /**
     * @return array
     */
    public function getLanguages(): array
    {
        return $this->languages;
    }

    /**
     * @return array
     */
    public function getCategories(): array
    {
        return $this->categories;
    }

    /**
     * @return array
     */
    public function getTargets(): array
    {
        return $this->targets;
    }

    /**
     * @return array
     */
    public function getImages(): array
    {
        return $this->images;
    }

    /**
     * @return array
     */
    public function getFiles(): array
    {
        return $this->files;
    }

    /**
     * @return array
     */
    public function getExternalLinks(): array
    {
        return $this->externalLinks;
    }

    /**
     * Constructor.
     *
     * @param BrochureAdapter $data
     * @return void
     */
    public function __construct($data)
    {
        $this->externalId = $data->getExternalId();
        $this->lastChange = $data->getLastChange();
        $this->title = $data->getTitle();
        $this->description = $data->getDescription();
        $this->type = $data->getType();
        $this->weight = $data->getWeight();
        $this->flagStatus = $data->getFlagStatus();
        $this->prospectCount = $data->getProspectCount();
        $this->size = $data->getSize();
        $this->address = $data->getAddress();
        $this->locations = $data->getLocations();
        $this->regions = $data->getRegion();
        $this->languages = $data->getLanguages();
        $this->images = $data->getImages();
        $this->files = $data->getFiles();

        $this->categories = array_map(
            function ($categoryData) {
                return new BrochureCategory($categoryData);
            },
            $data->getCategories()
        );
        $this->targets = array_map(
            function ($targetData) {
                return new BrochureTarget($targetData);
            },
            $data->getTargets()
        );
        $this->externalLinks = array_map(
            function ($externalLink) {
                return new BrochureExternalLink($externalLink);
            },
            $data->getExternalLinks()
        );
    }


    public function jsonSerialize()
    {
        return get_object_vars($this);
    }
}
