<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Brochure;

/**
 * Brochure repository.
 *
 * @Flow\Scope("singleton")
 */
class BrochureRepository
{
    /**
     * @param string $client
     * @return Brochure[]
     */
    public function findAllByClient(string $client)
    {
        return $this->brochureImportService->import($client);
    }
}
