<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\BrochureAdapterInterface;
use Newland\Toubiz\Api\Service\ServiceFactory;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ApiService;
use Newland\Toubiz\Sync\Neos\Exception\UnknownDataProviderException;
use Newland\Toubiz\Sync\Neos\Importer\BrochureImporter;

/**
 * Brochures command controller.
 *
 * Provides commands to manipulate brochure data.
 *
 * @Flow\Scope("singleton")
 */
class BrochuresCommandController extends AbstractCommandController
{

    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Synchronize command.
     *
     * Updates local brochures data from API data source.
     *
     * @param bool $quiet
     * @return void
     * @throws UnknownDataProviderException
     */
    public function synchronizeCommand($quiet = false)
    {
        if (!$quiet) {
            $this->showProgressOnCommandLine();
        }

        $configurationKey = 'Toubiz/Brochures/Api';

        $configuration = $this->getConfigurationForService($configurationKey);
        if (!$configuration) {
            throw new \Exception('Brochure data service not configured!');
        }

        $this->emitStart($configurationKey);

        /** @var ApiService $service */
        $service = ServiceFactory::get($configurationKey);
        $service->setApiKey($configuration['apiKey']);

        $brochures = $service->fetchBrochureList();
        $importer = new BrochureImporter();
        $importer->import($brochures);

        $this->emitEnd($configurationKey);
    }
}
