<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Translation\TranslatableEntity;

/**
 * A tag of an event.
 *
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="import_ident", columns={"language", "originalid"})
 * })
 */
class EventTag extends AbstractEntity
{
    use TranslatableEntity;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    protected $keyword = '';


    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Event", mappedBy="eventTags", fetch="LAZY")
     * @var Collection<Event>
     */
    protected $events;

    public function __construct()
    {
        $this->events = new ArrayCollection();
    }

    public function getEvents(): Collection
    {
        return $this->events;
    }

    public function setKeyword(string $keyword): void
    {
        $this->keyword = $keyword;
    }

    public function getKeyword(): string
    {
        return $this->keyword;
    }
}
