<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\TypeConverter;

use Neos\Flow\Property\Exception\TargetNotFoundException;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\TypeConverter\ArticleTypeConverter;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;

class ArticleTypeConverterTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var ArticleTypeConverter */
    protected $subject;

    /** @var ArticleFactory */
    protected $articleFactory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(ArticleTypeConverter::class);
        $this->articleFactory = new ArticleFactory($this->objectManager);
    }

    public function testResolvesById(): void
    {
        $article = $this->articleFactory->create();
        $fetched = $this->subject->convertFrom($article->getPersistenceObjectIdentifier(), Article::class, []);
        $this->assertEquals($article->getPersistenceObjectIdentifier(), $fetched->getPersistenceObjectIdentifier());
    }

    public function testThrowsExceptionIfNoArticleFound(): void
    {
        $this->expectException(TargetNotFoundException::class);
        $this->subject->convertFrom('foobar', Article::class, []);
    }

    public function testThrowsExceptionIfArticleHidden(): void
    {
        $this->expectException(TargetNotFoundException::class);
        $article = $this->articleFactory->create([ 'hidden' => true ]);
        $this->subject->convertFrom($article->getPersistenceObjectIdentifier(), Article::class, []);
    }
}
