<?php
namespace Newland\Toubiz\Sync\Neos\Service\Weather;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

class CopyrightService
{
    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Sync.Neos")
     */
    protected $syncConfiguration;

    /**
     * While the data itself is provider-agnostic, we still need to display a copyright notice
     *
     * @return array
     */
    public function getCopyrightInfo(): array
    {
        $dataProvider = $this->syncConfiguration['dataProvider']['weather'] ?? '';
        $services = $this->syncConfiguration['services']['weather'] ?? [];

        $copyrightInfo = $services[$dataProvider]['copyright'] ?? [ 'name' => '', 'url' => '' ];

        return $copyrightInfo;
    }
}
