<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\ErrorHandling;

use Neos\Error\Messages\Result;
use Neos\Flow\Validation\ValidatorResolver;
use Newland\Toubiz\Sync\Neos\Domain\Model\AbstractEntity;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class ValidationService
{

    /**
     * @var ValidatorResolver
     * @Flow\Inject()
     */
    protected $validatorResolver;

    /**
     * @param mixed|null $entity
     */
    public function validateEntity($entity, string $entityClassName = null): Result
    {
        if ($entity === null) {
            new Result();
        }

        return $this->validatorResolver
            ->getBaseValidatorConjunction($entityClassName ?? \get_class($entity))
            ->validate($entity);
    }
}
