<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20190709081346 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        if ($this->indexExists('newland_toubiz_sync_neos_domain_model_weather', 'newland_toubiz_sync_neos_weather_import_ident')) {
            $this->addSql('DROP INDEX newland_toubiz_sync_neos_weather_import_ident ON newland_toubiz_sync_neos_domain_model_weather');
        }
        $this->addSql('CREATE INDEX newland_toubiz_sync_neos_weather_import_ident ON newland_toubiz_sync_neos_domain_model_weather (location)');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('DROP INDEX newland_toubiz_sync_neos_weather_import_ident ON newland_toubiz_sync_neos_domain_model_weather');
        $this->addSql('CREATE INDEX newland_toubiz_sync_neos_weather_import_ident ON newland_toubiz_sync_neos_domain_model_weather (originalid)');
    }

    private function indexExists(string $table, string $indexName): bool
    {
        foreach ($this->sm->listTableIndexes($table) as $index) {
            if ($index->getName() === $indexName) {
                return true;
            }
        }
        return false;
    }
}
